//Listing 17.4. Przykad klasy szablonu z dwoma parametrami definiujcymi typ
#include <iostream>
using namespace std;

class Point;
ostream& operator << (ostream& out, const Point& p);

class Point {
      int x, y;
friend ostream& operator << (ostream& out, const Point& p);
public:
      Point() { } // domylny pusty konstruktor
      Point(const Point &p) // konstruktor kopiujcy
      { x = p.x; y = p.y; }
      Point(int a, int b) // konstruktor oglny: ustaw obiekt klasy Point
      { x = a; y = b; }
      void set(int a, int b) // ustaw wsprzdne punktu
      { x = a; y = b; }
      bool operator == (const Point& p) const
      { return x == p.x && y == p.y; }
} ;

ostream& operator << (ostream& out, const Point& p)
{ out << "(" << p.x << "," << p.y << ")";
  return out; }

template <class Key, class Data>
class DictEntry {
   Key key;
   Data info;
public:
  DictEntry () { } // pusty konstruktor domylny
  DictEntry(const Key& k, const Data& d)
      : key(k),info(d) {} // zainicjalizuj pola danych
  Key getKey() const
  { return key; } // zwr warto klucza
  Data getInfo() const
  { return info; } // zwr warto pola informacyjnego
  void setKey(const Key& k)
  { key = k; } // ustaw warto klucza
  void setInfo(const Data& d)
  { info = d; } // ustaw warto pola informacyjnego
} ;

int main()
{
  DictEntry<Point,char*> data[5];
  data[0].setKey(Point(1,2)); data[0].setInfo("Etap wstpny");
  data[1].setKey(Point(3,4)); data[1].setInfo("Analiza");
  data[2].setKey(Point(5,6)); data[2].setInfo("Projektowanie");
  data[3].setKey(Point(7,8)); data[3].setInfo("Implementacja");
  data[4].setKey(Point(9,0)); data[4].setInfo("Testowanie");
  int n = sizeof(data)/sizeof(DictEntry<Point,char*>); // ryzykowne
  cout << "Dane skojarzone:\n";
  for (int j = 0; j < n; j++)
  { cout << data[j].getKey() << " "
  << data[j].getInfo() << endl; } // wywietl dane wejciowe
  cout << endl;
  return 0;
}
